//+------------------------------------------------------------------+
//| Indicator of time to end of candle v0.3 forexpvm(k))             |
//+------------------------------------------------------------------+
#property copyright "forexpvm"
#property link      "http://forexpvm.at.ua/"
#property indicator_chart_window
//---- external
extern double eAlertDelta=      4; // minutes
extern int    eAlertShow=       1; // 0-not show, 1 - show
extern double eAlertShowDelta=  1; // Minutes
extern string eAlertScreenName= "Scr#1: "; // name identify alert message 
extern string eAlertMsg=        "Minutes to Candle close: "; // name identify alert message 
extern string eAlertStrMacro=   "%nc_AlertScreenName%%nc_GraphName%: %nc_AlertMsg%%nc_MinutesToClose% (cur:%nc_TimeCurrent%)(open:%nc_TimeCandleOpen%)(close:%nc_TimeCandleClose%)(%nc_Bid%/%nc_Ask%)";
extern string eCommentAttention="[!] ";
extern string eCommentStrMacro= "%nc_AlertScreenName%%nc_MinutesToClose% (cur:%nc_TimeCurrent%)(open:%nc_TimeCandleOpen%)(close:%nc_TimeCandleClose%)(%nc_Bid%/%nc_Ask%)";
//Scr#1: EURUSD(M5): Minutes to Candle close: 2.32(cur:2009.09.10 09:22:41)(open:2009.09.10 09:20)(close:2009.09.10 09:25)(1.4572/1.4574)
extern int MagicNumber=         20090909;
//---- END external

string nc_AlertScreenName="%nc_AlertScreenName%";
string nc_AlertMsg=       "%nc_AlertMsg%";
string nc_GraphName=      "%nc_GraphName%";
string nc_MinutesToClose= "%nc_MinutesToClose%";
string nc_TimeCandleClose="%nc_TimeCandleClose%";
string nc_TimeCandleOpen= "%nc_TimeCandleOpen%";
string nc_TimeCurrent=    "%nc_TimeCurrent%";
string nc_Bid=            "%nc_Bid%";
string nc_Ask=            "%nc_Ask%";

string    my_name="forexpvm:TTE",gGraphName,gAlertMessage;
datetime  gLastTimeM1;
double    gPeriodDelta,gPeriodDeltaM1;
int       gLastTimeAlert;
double    gLastTimeDelta;
string    g_ipl_StrRepl_1,g_ipl_StrRepl_2;
//+------------------------------------------------------------------+
int init()
{
  IndicatorShortName(my_name);
  gPeriodDelta  =Time[1]-Time[2];
  gPeriodDeltaM1=60;
  gLastTimeAlert=TimeCurrent();
  gGraphName    =Symbol()+ "(" + ipl_Get_Period_Name(Period()) + ")" ;
  return(0);
}
int deinit()
{
  Comment("");
  return(0);
}
int start()
{
  gLastTimeM1=    TimeCurrent();
  gLastTimeDelta= ((Time[0]+gPeriodDelta-gLastTimeM1)/gPeriodDeltaM1);
  if ((eAlertDelta)<gLastTimeDelta)
  {
    gAlertMessage=Get_Alert_Msg(eCommentStrMacro);
    Comment(my_name + ":" + gAlertMessage);
  } else
  {
    gAlertMessage=Get_Alert_Msg(eCommentStrMacro);
    Comment(my_name + ":" + eCommentAttention + gAlertMessage);
    if(eAlertShow==1)
    {
      if(eAlertShowDelta<=(TimeCurrent()-gLastTimeAlert)/gPeriodDeltaM1)
      {
        gAlertMessage=Get_Alert_Msg(eAlertStrMacro);
        Alert(gAlertMessage);
        gLastTimeAlert=TimeCurrent();
      }
    }
  }
  return(0);
}

string Get_Alert_Msg(string p_Msg_Macro)
{string ret=p_Msg_Macro;

  if (ipl_Str_Replace_Prepare(ret,nc_AlertMsg)!=-1){
    ret=ipl_Str_Replace(eAlertMsg);
  }

  if (ipl_Str_Replace_Prepare(ret,nc_AlertScreenName)!=-1){
    ret=ipl_Str_Replace(eAlertScreenName);
  }

  if (ipl_Str_Replace_Prepare(ret,nc_GraphName)!=-1){
    ret=ipl_Str_Replace(gGraphName);
  }

  if (ipl_Str_Replace_Prepare(ret,nc_MinutesToClose)!=-1){
    string i_tm_hours_str="",i_tm_minutes_str="";
    int i_tm_minutes=StrToInteger(DoubleToStr(gLastTimeDelta,8));
    string i_tm_secs_str=DoubleToStr((Time[0]+gPeriodDelta-gLastTimeM1)-i_tm_minutes*gPeriodDeltaM1,0);
    if (gLastTimeDelta>=60)
    {
    int i_tm_hours=StrToInteger(DoubleToStr(i_tm_minutes/60,8));
      i_tm_hours_str=i_tm_hours + ":";
      i_tm_minutes_str=DoubleToStr(i_tm_minutes-i_tm_hours*60,0);
    }else{
    i_tm_minutes_str=i_tm_minutes;
    }
    ret=ipl_Str_Replace(i_tm_hours_str+i_tm_minutes_str+":"+i_tm_secs_str);
  }

  if (ipl_Str_Replace_Prepare(ret,nc_TimeCandleClose)!=-1){
    ret=ipl_Str_Replace(TimeToStr(Time[0]+gPeriodDelta,TIME_MINUTES));
  }

  if (ipl_Str_Replace_Prepare(ret,nc_TimeCandleOpen)!=-1){
    ret=ipl_Str_Replace(TimeToStr(Time[0],TIME_MINUTES));
  }

  if (ipl_Str_Replace_Prepare(ret,nc_TimeCurrent)!=-1){
    ret=ipl_Str_Replace(TimeToStr(TimeCurrent(),TIME_DATE|TIME_SECONDS));
  }

  if (ipl_Str_Replace_Prepare(ret,nc_Bid)!=-1){
    ret=ipl_Str_Replace(DoubleToStr(Bid,4));
  }

  if (ipl_Str_Replace_Prepare(ret,nc_Ask)!=-1){
    ret=ipl_Str_Replace(DoubleToStr(Ask,4));
  }
  return(ret);
}
string ipl_Get_Period_Name(int p_period)
{string ret="";
  switch(p_period)
  {
    case 1:     ret="M1"; break;
    case 5:     ret="M5"; break;
    case 15:    ret="M15";break;
    case 30:    ret="M30";break;
    case 60:    ret="H1"; break;
    case 240:   ret="H4"; break;
    case 1440:  ret="D1"; break;
    case 10080: ret="W1"; break;
    case 43200: ret="MN1";break;
  }
  return(ret);
}
//-----------------------
// funcs ipl_Str_ReplaceXXX
// used global vars: string g_ipl_StrRepl_1,g_ipl_StrRepl_2;
//
string ipl_Str_Replace(string p_new_string="")
{string ret;
  ret=StringConcatenate(g_ipl_StrRepl_1,p_new_string,g_ipl_StrRepl_2);
  return(ret);
}
int ipl_Str_Replace_Prepare(string p_String,string p_SearchStr)
{string tmp,ss;int pos;
  tmp=StringChangeToLowerCase(p_String);
  ss=StringChangeToLowerCase(p_SearchStr);
  pos=StringFind(tmp,ss);
  if (pos!=-1){
    if(pos!=0)
    {
      g_ipl_StrRepl_1=StringSubstr(p_String,0,pos);
    }else{
      g_ipl_StrRepl_1="";
    }
    g_ipl_StrRepl_2=StringSubstr(p_String,pos+StringLen(p_SearchStr));
  }else{
    g_ipl_StrRepl_1="";g_ipl_StrRepl_2="";
  }
  return(pos);
}
// END funcs ipl_Str_ReplaceXXX
//-----------------------
string StringChangeToUpperCase(string sText) {
  // (k)sx_ted 2006.11.20 00:03 (http://forum.mql4.com/4891)
  // Example: StringChangeToUpperCase("oNe mAn"); // ONE MAN 
  int iLen=StringLen(sText), i, iChar;
  for(i=0; i < iLen; i++) {
    iChar=StringGetChar(sText, i);
    if(iChar >= 97 && iChar <= 122) sText=StringSetChar(sText, i, iChar-32);
  }
  return(sText);
}
 
string StringChangeToLowerCase(string sText) {
  // (k)sx_ted 2006.11.20 00:03 (http://forum.mql4.com/4891)
  // Example: StringChangeToLowerCase("oNe mAn"); // one man
  int iLen=StringLen(sText), i, iChar;
  for(i=0; i < iLen; i++) {
    iChar=StringGetChar(sText, i);
    if(iChar >= 65 && iChar <= 90) sText=StringSetChar(sText, i, iChar+32);
  }
  return(sText);  
}
 
string StringChangeFirstToUpperCase(string sText) {
  // (k)sx_ted 2006.11.20 00:03 (http://forum.mql4.com/4891)
  // Example: StringChangeFirstToUpperCase("oNe mAn"); // One Man
  int iLen=StringLen(sText), i, iChar, iLast=32;
  for(i=0; i < iLen; i++) {
    iChar=StringGetChar(sText, i);
    if(iLast==32 && iChar >= 97 && iChar <= 122) sText=StringSetChar(sText, i, iChar-32);
    else if(iLast!=32 && iChar >= 65 && iChar <= 90) sText=StringSetChar(sText, i, iChar+32);
    iLast=iChar;
  }
  return(sText);  
}