//+------------------------------------------------------------------+
//|                                     ep_skdon_forexpvm_public.mq4 |
//|                                                 version=20120131 |
//|                                Copyright  2011, skdon, forexpvm |
//|                                       http://www.forexpvm.at.ua/ |
//+------------------------------------------------------------------+
/*
version=20120131:
added e_Signal_Reverse
version=20110328
*/
#property copyright "skdon, forexpvm"
#property link      "http://forexpvm.at.ua"
#define MagicNumber  201103280017
string gmy_name   = "ep_sts_forexpvm:";

extern string s_version   = "20120131";
extern int    e_MaMetod   = 3;
extern int    e_MaPeriod  = 20;
extern int    e_Signal_Reverse = 0; // 0-  skdon, 1-

extern double e_Lots              = 0.1;
//     
extern int    e_Trail_Pips        = 60;
//     ( ,    = 1)
extern int    e_Trail_Ratio       = 1;
//    ,      (   )
extern double e_Close_Profit      = 700; //in account currency
//    
extern double e_SL                = 60;
//    
extern double e_TP                = 310;
//
extern int    e_Slippage          = 10;
//   ,    e_Trail_Ratio:
//1 - , 0 - 
//  1
extern int    e_TrailFromOrder    = 1;
//,     
extern int    e_TrailTimeMinute   = 15;

 int    e_Array_Baraban_Len = 10;
 double e_MaximumRisk       = 0.02;
 double e_DecreaseFactor    = 3;

//lots optimizer:>
int     gLastCmd            = 0;
int     gLastSell           = 0;
int     gLastBuy            = 0;
int     gLastTradeResult    = 0;
int     gMaxGoodTrend       = 0;
double  gMaxGoodTrendSellBuy    = 1;
double  gMaxGoodTrendAvg        = 0;
double  gMaxGoodTrendSellBuyAvg = 1;
int     gSell_losses        = 0;
int     gBuy_losses         = 0;
int     gSell_profes        = 0;
int     gBuy_profes         = 0;
//lots optimizer<:

//indicator:>
double  buf_1[];
double  buf_2[];
double  buf_3[];
double  buf_4[];
double  buf_5_up[];
double  buf_6_dn[];
double  d_ma_C;
double  d_ma_L;
double  d_ma_O;
double  d_ma_H;
double  d_value_prev;
double  d_value_max;
double  d_value_min;
double  d_value_cur;
//indicator<:

int     g_Orders_Closed     = 0;
int     g_Orders_SL_Moved   = 0;
int     g_Orders_Closed_Err = 0;
double  g_Order_Trail_Price;

int     gTimeLast;
int     g_TrailTimeNext = 0;
int     i_counted       = 0;

void init()
{
  g_Order_Trail_Price = NormalizeDouble(10 * Point * e_Trail_Pips, 4);
  gTimeLast = Time[2];
	ArrayResize( buf_1,	e_Array_Baraban_Len );
	ArrayResize( buf_2,	e_Array_Baraban_Len );
	ArrayResize( buf_3,	e_Array_Baraban_Len );
	ArrayResize( buf_4,	e_Array_Baraban_Len );
	ArrayResize( buf_5_up, e_Array_Baraban_Len );
	ArrayResize( buf_6_dn, e_Array_Baraban_Len );

  /*for(int v_index=0; v_index<=3; v_index++)
  {
    buf_1[arr_baraban_get_id(v_index)]    = Ask;
    buf_2[arr_baraban_get_id(v_index)]    = Ask;
    buf_3[arr_baraban_get_id(v_index)]    = Ask;
    buf_4[arr_baraban_get_id(v_index)]    = Ask;
    buf_5_up[arr_baraban_get_id(v_index)] = 0;
    buf_6_dn[arr_baraban_get_id(v_index)] = 0;
  }*/
  d_ma_C = iMA(NULL, 0, e_MaPeriod, 0, e_MaMetod, PRICE_CLOSE, 1);
  d_ma_L = iMA(NULL, 0, e_MaPeriod, 0, e_MaMetod, PRICE_LOW,   1);
  d_ma_O = iMA(NULL, 0, e_MaPeriod, 0, e_MaMetod, PRICE_OPEN,  1);
  d_ma_H = iMA(NULL, 0, e_MaPeriod, 0, e_MaMetod, PRICE_HIGH,  1);
  i_counted = 0;
  buf_3[arr_baraban_get_id(i_counted)]    = (d_ma_C + d_ma_H + d_ma_O + d_ma_L) / 4.0;
  buf_4[arr_baraban_get_id(i_counted)]    = (d_ma_C + d_ma_H + d_ma_O + d_ma_L) / 4.0;
  
  return(0);
}

void deinit()
{
  Print("Point              : ",Point);
  Print("g_Orders_SL_Moved  : ",g_Orders_SL_Moved);
  Print("g_Orders_Closed    : ",g_Orders_Closed);
  Print("g_Orders_Closed_Err: ",g_Orders_Closed_Err);
  Print("g_Order_Trail_Price: ",g_Order_Trail_Price);
}
void start()
{
  if(/*Bars<10 ||*/ IsTradeAllowed()==false)  return;
  CheckForTrailStopLoss();
  //CheckForClose();
  if(gTimeLast!=Time[1])
  {
    gTimeLast = Time[1];
    int i_bar = i_counted + 1;

    d_ma_C = iMA(NULL, 0, e_MaPeriod, 0, e_MaMetod, PRICE_CLOSE, 1);
    d_ma_L = iMA(NULL, 0, e_MaPeriod, 0, e_MaMetod, PRICE_LOW,   1);
    d_ma_O = iMA(NULL, 0, e_MaPeriod, 0, e_MaMetod, PRICE_OPEN,  1);
    d_ma_H = iMA(NULL, 0, e_MaPeriod, 0, e_MaMetod, PRICE_HIGH,  1);
    
    d_value_prev  = (buf_3[arr_baraban_get_id(i_bar - 1)] + (buf_4[arr_baraban_get_id(i_bar - 1)])) / 2.0;
    d_value_cur   = (d_ma_C + d_ma_H + d_ma_O + d_ma_L) / 4.0;
    d_value_max   = MathMax(d_ma_H, MathMax(d_value_prev, d_value_cur));
    d_value_min   = MathMin(d_ma_O, MathMin(d_value_prev, d_value_cur));
    
    arr_baraban_clear_id(i_bar);
    
    if (d_value_prev < d_value_cur)
    {
      buf_1[arr_baraban_get_id(i_bar)] = d_value_min;
      buf_2[arr_baraban_get_id(i_bar)] = d_value_max;
    } else {
      buf_2[arr_baraban_get_id(i_bar)] = d_value_min;
      buf_1[arr_baraban_get_id(i_bar)] = d_value_max;
    }
    buf_3[arr_baraban_get_id(i_bar)] = d_value_prev;
    buf_4[arr_baraban_get_id(i_bar)] = d_value_cur;
    if (i_counted>4) fn_check_signal(i_bar,"");
   //if(CalculateCurrentOrders(Symbol())==0) 
    {
      CheckForOpen(i_bar);
    }
    i_counted = i_bar;
  }
  return (0);
}

void fn_check_signal(int i_bar,string p_direction)
{
  if ( buf_1[arr_baraban_get_id(i_bar)]     < buf_2[arr_baraban_get_id(i_bar)]
    && buf_1[arr_baraban_get_id(i_bar - 1)] < buf_2[arr_baraban_get_id(i_bar - 1)]
    && buf_1[arr_baraban_get_id(i_bar - 2)] > buf_2[arr_baraban_get_id(i_bar - 2)]
    && buf_1[arr_baraban_get_id(i_bar - 3)] > buf_2[arr_baraban_get_id(i_bar - 3)])
  { 
    buf_5_up[arr_baraban_get_id(i_bar)] = d_value_min - 250.0 * Point;
    drow_arrow(gmy_name + "arrow_" + i_bar,Time[0],buf_5_up[arr_baraban_get_id(i_bar)],SYMBOL_ARROWUP,Blue );
  }else
  {
    if ( buf_1[arr_baraban_get_id(i_bar)]     > buf_2[arr_baraban_get_id(i_bar)]
      && buf_1[arr_baraban_get_id(i_bar - 1)] > buf_2[arr_baraban_get_id(i_bar - 1)]
      && buf_1[arr_baraban_get_id(i_bar - 2)] < buf_2[arr_baraban_get_id(i_bar - 2)]
      && buf_1[arr_baraban_get_id(i_bar - 3)] < buf_2[arr_baraban_get_id(i_bar - 3)])
    {
      buf_6_dn[arr_baraban_get_id(i_bar)] = d_value_max + 250.0 * Point;
      drow_arrow(gmy_name + "arrow_" + i_bar,Time[0],buf_6_dn[arr_baraban_get_id(i_bar)],SYMBOL_ARROWDOWN,Red );
    }
  }
}

void fn_OpenOrder(int p_direction)
{
  int     res;
  bool    v_closed;
  double  SL, TP;
  v_closed = CloseAllOrders();
  if(v_closed)
  {
    if (p_direction==1)
    {
      gLastBuy++;
      SL  = Ask - e_SL * 0.0001;
      TP  = e_TP * 0.0001 + Ask;
      res = ip_order_send(Symbol(),OP_BUY,e_Lots,NormalizeDouble(Ask,4),e_Slippage,SL,TP,"",MagicNumber,0,Blue);
    }else
    {
      gLastSell++;
      SL  = e_SL * 0.0001 + Bid;
      TP  = Bid - e_TP * 0.0001;
      res = ip_order_send(Symbol(),OP_SELL,e_Lots,NormalizeDouble(Bid,4),e_Slippage,SL,TP,"",MagicNumber,0,Red);
    }
  }
}

void CheckForOpen(int i_bar)
{
  if(buf_5_up[arr_baraban_get_id(i_bar)] > 0) 
  {
    {
      if (e_Signal_Reverse==0)
      {
        fn_OpenOrder (1);
      }else
      {
        fn_OpenOrder (2);
      }
    }
  }else
  if(buf_6_dn[arr_baraban_get_id(i_bar)] > 0) 
  {
    {
      if (e_Signal_Reverse==0)
      {
        fn_OpenOrder (2);
      }else
      {
        fn_OpenOrder (1);
      }
    }
  }
}
//+------------------------------------------------------------------+
bool CloseAllOrders()
{
  bool v_ret = true;
  for(int i=0; i<OrdersTotal(); i++)
  {
    if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES) == false) break;
    if(OrderMagicNumber() != MagicNumber || OrderSymbol() != Symbol()) continue;
    RefreshRates();
    
    if(OrderType() == OP_BUY)
    {
      if(OrderProfit() > e_Close_Profit)
      {
        if(OrderClose(OrderTicket(),OrderLots(),Bid,e_Slippage,White))
        {
          g_Orders_Closed++;
        }
        else
        {
          g_Orders_Closed_Err++;
          v_ret = false;
        }
      }
      else
      {
        v_ret = false;
      }
    }
    else
    {
      if(OrderType() == OP_SELL)
      {
        if(OrderProfit() > e_Close_Profit)
        {
          if(OrderClose(OrderTicket(),OrderLots(),Ask,e_Slippage,White))
          {
            g_Orders_Closed++;
          }
          else
          {
            g_Orders_Closed_Err++;
            v_ret = false;
          }
        }
        else
        {
          v_ret = false;
        }
      }
    }
  }
  return (v_ret);
}
//+------------------------------------------------------------------+
void CheckForClose()
{ // unused in this version
  for(int i=0; i<OrdersTotal(); i++)
  {
    if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES) == false) break;
    if(OrderMagicNumber() != MagicNumber || OrderSymbol() != Symbol()) continue;
    RefreshRates();
    if(OrderType() == OP_BUY)
    {
      if(NormalizeDouble((Bid - OrderOpenPrice()) - g_Order_Trail_Price,4) > 0.0000)
      {
        OrderClose(OrderTicket(),OrderLots(),Bid,e_Slippage,White);
        g_Orders_Closed++;
      }
    }
    else
    {
      if(OrderType() == OP_SELL)
      {
        if(NormalizeDouble((OrderOpenPrice() - Ask) - g_Order_Trail_Price,4) > 0.0000)
        {
          OrderClose(OrderTicket(),OrderLots(),Ask,e_Slippage,White);
          g_Orders_Closed++;
        }
      }
    }
  }
}
//+------------------------------------------------------------------+
void CheckForTrailStopLoss()
{
  if (g_TrailTimeNext>TimeCurrent()) return;
  for(int i=0; i<OrdersTotal(); i++)
  {
    if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES) == false) break;
    if(OrderMagicNumber() != MagicNumber || OrderSymbol() != Symbol()) continue;
    RefreshRates();
    //if (OrderProfit() > 0.0)
    {
      if(OrderType() == OP_BUY)
      {
        //if(OrderStopLoss() < OrderOpenPrice())
        {
          if(MathMax(OrderOpenPrice(),OrderStopLoss()) < Bid - e_Trail_Ratio * g_Order_Trail_Price)
          {
            //if(OrderStopLoss() < Bid-e_Trail_Ratio * g_Order_Trail_Price)
            {
              TrailTheOrder(1);
            }
          }
        }
      }
      else
      {
        if(OrderType() == OP_SELL)
        {
          //if(OrderStopLoss() > OrderOpenPrice())
          {
            if(MathMin(OrderOpenPrice(),OrderStopLoss()) > Ask + e_Trail_Ratio * g_Order_Trail_Price)
            {
              //if(OrderStopLoss() > Ask + e_Trail_Ratio * g_Order_Trail_Price)
              {
              TrailTheOrder(-1);
              }
            }
          }
        }
      }
    }
  }
}

void TrailTheOrder(int p_direction)
{
  bool res = false;
  if (e_TrailFromOrder==1)
  {
    //OrderModify(OrderTicket(),OrderOpenPrice(),OrderOpenPrice()+p_direction*g_Order_Trail_Price,OrderTakeProfit(),0,Blue);
    if (p_direction>0)
    {
      if(Ask -((MathMax(OrderOpenPrice(),OrderStopLoss())+p_direction*g_Order_Trail_Price) )>g_Order_Trail_Price)
      res = OrderModify(OrderTicket(),OrderOpenPrice(),MathMax(OrderOpenPrice(),OrderStopLoss())+p_direction*g_Order_Trail_Price,OrderTakeProfit(),0,Blue);
    }
    else
    {
      if(-Bid+((MathMin(OrderOpenPrice(),OrderStopLoss())+p_direction*g_Order_Trail_Price) )>g_Order_Trail_Price)
      res = OrderModify(OrderTicket(),OrderOpenPrice(),MathMin(OrderOpenPrice(),OrderStopLoss())+p_direction*g_Order_Trail_Price,OrderTakeProfit(),0,Blue);
    }
  }
  else
  {
    if (p_direction>0)
    {
      res = OrderModify(OrderTicket(),OrderOpenPrice(),Bid-p_direction*g_Order_Trail_Price,OrderTakeProfit(),0,Blue);
    }
    else
    {
      res = OrderModify(OrderTicket(),OrderOpenPrice(),Ask-p_direction*g_Order_Trail_Price,OrderTakeProfit(),0,Blue);
    }
  }
  if (res)
  {
    g_Orders_SL_Moved++;
    g_TrailTimeNext = e_TrailTimeMinute*60 + TimeCurrent();
  }
}
//+------------------------------------------------------------------+
int arr_baraban_get_id(int p_index /*, int p_len*/)
{
  return(MathMod(p_index, e_Array_Baraban_Len /*p_len*/));
}

void arr_baraban_clear_id(int p_index /*, int p_len*/)
{
  int v_index       = arr_baraban_get_id(p_index /*, p_len*/);
  buf_1[v_index]    = 0.0;
  buf_2[v_index]    = 0.0;
  buf_3[v_index]    = 0.0;
  buf_4[v_index]    = 0.0;
  buf_5_up[v_index] = 0.0;
  buf_6_dn[v_index] = 0.0;
}
//+------------------------------------------------------------------+
void drow_line(string name,datetime t1,double price1,datetime t2,double price2,color colr)
{ // unused in this version
  ObjectCreate(name,OBJ_TREND,0,t1,price1,t2,price2,NULL,NULL);
  ObjectSet   (name,OBJPROP_BACK, true);
  ObjectSet   (name,OBJPROP_RAY, false);
  ObjectSet   (name,OBJPROP_STYLE, 0); 
  ObjectSet   (name,OBJPROP_WIDTH, 1);
  ObjectSet   (name,OBJPROP_COLOR, colr);
}

void drow_arrow(string name,datetime t1,double price1,int p_ARROWCODE,color p_color=Red )
{
  ObjectCreate(name,OBJ_ARROW,0,t1,price1);
  ObjectSet   (name,OBJPROP_BACK, true);
  ObjectSet   (name,OBJPROP_RAY, false);
  ObjectSet   (name,OBJPROP_ARROWCODE, p_ARROWCODE); 
  ObjectSet   (name,OBJPROP_WIDTH, 1);
  ObjectSet   (name,OBJPROP_COLOR, p_color);
}
//+------------------------------------------------------------------+
int ip_order_send(string symbol, int cmd, double volume, double price, int slippage, double stoploss,
                  double takeprofit, string comment="", int magic=0, datetime expiration=0,
                  color arrow_color=CLR_NONE)
{
  int v_cicle = 100;
  int v_ticket;
  while( v_cicle > 0 )
  {
    v_ticket = OrderSend(symbol, cmd, volume, price, slippage, stoploss, takeprofit, comment, magic, expiration, arrow_color);
    if(v_ticket <= 0)
    {
      int error = GetLastError();
      //---- not enough money
      if(error == 134) break;
      //---- 10 seconds wait
      Sleep(10000);
      //---- refresh price data
      RefreshRates();
      break;
    }
    else
    {
      break;
    }
    v_cicle--;
  }
  if (v_ticket <= 0){
    Print("ip_order_send:ERR:",cmd,";", volume,";", price,";", slippage,";", stoploss,";", takeprofit);
  }
  else
  {
    g_TrailTimeNext = e_TrailTimeMinute*60 + TimeCurrent();
  }
  return (v_ticket);
}
//+------------------------------------------------------------------+
// ToDo:
double Get_Optimized_Lots()
{ // unused in this version
  double lot=e_Lots;
  int    orders=HistoryTotal();
  int    losses=0;
  int    profes=0;
  int    Sell_losses  = 0;
  int    Buy_losses   = 0;
  int    Sell_profes  = 0;
  int    Buy_profes   = 0;
  int    LastCmd      = -1;

  int     LastGoodTrend         = 0;
  double  LastGoodTrendSellBuy  = 1;

  int PriorCmd  = -1;
  //OP_BUY 0 Buying position. 
  //OP_SELL 1 Selling position. 

  gLastTradeResult        = 0;
  gMaxGoodTrend           = 0;
  gMaxGoodTrendSellBuy    = 1.0;
  gMaxGoodTrendAvg        = 0.0;
  gMaxGoodTrendSellBuyAvg = 1.0;
  gSell_losses  = 0;
  gBuy_losses   = 0;

  lot=NormalizeDouble(AccountFreeMargin()*e_MaximumRisk/1000.0,1);
  if(e_DecreaseFactor>0)
  {
  for(int i=orders-1;i>=0;i--)
  {
  if(OrderSelect(i,SELECT_BY_POS,MODE_HISTORY)==false) { Print("Error in history!"); break; }
  if(OrderSymbol()!=Symbol() || OrderType()>OP_SELL) continue;
  LastCmd = OrderType();
  if(OrderProfit()>0)
  { profes++;
  gSell_profes+= LastCmd;
  gBuy_profes+=(1- LastCmd);
  if (PriorCmd== LastCmd)
  {
  Sell_profes+= LastCmd;
  Buy_profes+=(1- LastCmd);

  LastGoodTrend++;

  }else{
  if (LastGoodTrend > 1)
  {
  gMaxGoodTrendAvg       = (gMaxGoodTrendAvg + gMaxGoodTrend)/2;
  gMaxGoodTrend = MathMax(gMaxGoodTrend,LastGoodTrend);
  LastGoodTrend = 0;
  PriorCmd = LastCmd;
  }
  }
  }else
  if(OrderProfit()<0)
  { losses++;
  Sell_losses+= LastCmd;
  Buy_losses+=(1- LastCmd);
  }
  }
  if(losses>1) lot=NormalizeDouble(lot-lot*losses/e_DecreaseFactor,1);
  }
  if(lot<0.1) lot=0.1;
  return(lot);
}
//+------------------------------------------------------------------+

